@charset "UTF-8";

/* --- bb_code.css --- */

/* .bbCodeX classes are designed to exist inside .baseHtml. ie: they have no CSS reset applied */

.bbCodeBlock
{
	background-color: rgb(228, 240, 247);
margin: 1em 140px 1em 0;
border: 1px solid rgb(194,218,234);
-webkit-border-radius: 2px; -moz-border-radius: 2px; -khtml-border-radius: 2px; border-radius: 2px;
overflow: auto;

}

	.bbCodeBlock .bbCodeBlock,
	.hasJs .bbCodeBlock .bbCodeSpoilerText,
	.messageList.withSidebar .bbCodeBlock
	{
		margin-right: 0;
	}

	/* mini CSS reset */
	.bbCodeBlock pre,
	.bbCodeBlock blockquote
	{
		margin: 0;
	}
	
	.bbCodeBlock img
	{
		border: none;
	}

.bbCodeBlock .type
{
	font-size: 13px;
font-family: 'Open Sans', Arial, sans-serif;
color: rgb(52,77,93);
padding: 8px;
border-bottom: 1px solid rgb(194,218,234);
-webkit-border-top-left-radius: 2px; -moz-border-radius-topleft: 2px; -khtml-border-top-left-radius: 2px; border-top-left-radius: 2px;
-webkit-border-top-right-radius: 2px; -moz-border-radius-topright: 2px; -khtml-border-top-right-radius: 2px; border-top-right-radius: 2px;

}

.bbCodeBlock pre,
.bbCodeBlock .code
{
	font-size: 10pt;
font-family: 'Source Code Pro', Consolas, 'Courier New', Courier, monospace;
background-repeat: repeat-x;
background-position: top;
padding-right: 8px;
padding-left: 8px;
-webkit-border-bottom-right-radius: 2px; -moz-border-radius-bottomright: 2px; -khtml-border-bottom-right-radius: 2px; border-bottom-right-radius: 2px;
-webkit-border-bottom-left-radius: 2px; -moz-border-radius-bottomleft: 2px; -khtml-border-bottom-left-radius: 2px; border-bottom-left-radius: 2px;
word-wrap: normal;
overflow: auto;
line-height: 26px;
min-height: 30px;
max-height: 500px;
_width: 600px;
direction: ltr;


background-image:-webkit-repeating-linear-gradient(top, rgba(0,0,0,.015) 0px, rgba(0,0,0,.015) 26px, rgba(0,0,0,.045) 26px, rgba(0,0,0,.045) 52px);
background-image:-moz-repeating-linear-gradient(top, rgba(0,0,0,.015) 0px, rgba(0,0,0,.015) 26px, rgba(0,0,0,.045) 26px, rgba(0,0,0,.045) 52px);
background-image:-ms-repeating-linear-gradient(top, rgba(0,0,0,.015) 0px, rgba(0,0,0,.015) 26px, rgba(0,0,0,.045) 26px, rgba(0,0,0,.045) 52px);
background-image:-o-repeating-linear-gradient(top, rgba(0,0,0,.015) 0px, rgba(0,0,0,.015) 26px, rgba(0,0,0,.045) 26px, rgba(0,0,0,.045) 52px);
background-image:repeating-linear-gradient(top, rgba(0,0,0,.015) 0px, rgba(0,0,0,.015) 26px, rgba(0,0,0,.045) 26px, rgba(0,0,0,.045) 52px);

}

.bbCodeBlock .code
{
	white-space: nowrap;
}

.bbCodeQuote
{
	border-color: rgb(194,218,234);

}

.bbCodeQuote .attribution
{
	font-size: 13px;
color: rgb(52,77,93);
background-repeat: repeat-x;
background-position: top;
padding: 8px;
border-bottom: 1px solid rgb(194,218,234);

}

.bbCodeQuote .quoteContainer
{
	overflow: hidden;
	position: relative;
	
	font-style: italic;
font-size: 9pt;
background-color: rgb(228, 240, 247);
background-repeat: repeat-x;
background-position: top;
padding: 8px;

}


	.bbCodeQuote .quoteContainer .quote
	{
		max-height: 150px;
		overflow: hidden;
		padding-bottom: 1px;
	}
	
		.NoJs .bbCodeQuote .quoteContainer .quote
		{
			max-height: none;
		}

	.bbCodeQuote .quoteContainer .quoteExpand
	{		
		display: none;
		-webkit-box-sizing: border-box; -moz-box-sizing: border-box; -ms-box-sizing: border-box; box-sizing: border-box;
		position: absolute;
		height: 80px;
		top: 86px;
		left: 0;
		right: 0;
		
		font-size: 11px;
		line-height: 1;
		text-align: center;
		color: rgb(175, 207, 226);
		cursor: pointer;
		padding-top: 65px;
		background: -webkit-linear-gradient(top, rgba(228, 240, 247, 0) 0%, rgb(228, 240, 247) 80%);
		background: -moz-linear-gradient(top, rgba(228, 240, 247, 0) 0%, rgb(228, 240, 247) 80%);
		background: -o-linear-gradient(top, rgba(228, 240, 247, 0) 0%, rgb(228, 240, 247) 80%);
		background: linear-gradient(to bottom, rgba(228, 240, 247, 0) 0%, rgb(228, 240, 247) 80%);
		
		border-bottom-left-radius: ;
		border-bottom-right-radius: ;
	}
	
	.bbCodeQuote .quoteContainer .quoteExpand.quoteCut
	{
		display: block;
	}
	
	.bbCodeQuote .quoteContainer.expanded .quote
	{
		max-height: none;
	}
	
	.bbCodeQuote .quoteContainer.expanded .quoteExpand
	{
		display: none;
	}


	.bbCodeQuote img
	{
		max-height: 150px;
	}
	
	.bbCodeQuote iframe,
	.bbCodeQuote object,
	.bbCodeQuote embed
	{
		max-width: 200px;
		max-height: 150px;
	}
	
	.bbCodeQuote iframe:-webkit-full-screen
	{
		max-width: none;
		max-height: none;
	}
	
	.bbCodeQuote iframe:-moz-full-screen
	{
		max-width: none;
		max-height: none;
	}
	
	.bbCodeQuote iframe:-ms-fullscreen
	{
		max-width: none;
		max-height: none;
	}
	
	.bbCodeQuote iframe:fullscreen
	{
		max-width: none;
		max-height: none;
	}
	
.bbCodeSpoilerButton
{
	margin: 5px 0;
	max-width: 99%;
}

	.bbCodeSpoilerButton > span
	{
		display: inline-block;
		max-width: 100%;
		white-space: nowrap;
		text-overflow: ellipsis;
		overflow: hidden;
	}
	
.hasJs .bbCodeSpoilerText
{
	display: none;
	background-color: #FFFFFF;
padding: 5px;
margin-top: 5px;
margin-right: ;
margin-bottom: 5px;
border: 1px solid rgb(249, 253, 255);
-webkit-border-radius: 5px; -moz-border-radius: 5px; -khtml-border-radius: 5px; border-radius: 5px;
overflow: auto;

}

	.hasJs .bbCodeSpoilerText .bbCodeSpoilerText,
	.hasJs .bbCodeSpoilerText .bbCodeBlock,
	.hasJs .messageList.withSidebar .bbCodeSpoilerText
	{
		margin-right: 0;
	}
	
.NoJs .bbCodeSpoilerContainer
{
	background-color: rgb(44, 44, 44); /* fallback for browsers without currentColor */
	background-color: currentColor;
}

	.NoJs .bbCodeSpoilerContainer > .bbCodeSpoilerText
	{
		visibility: hidden;
	}

	.NoJs .bbCodeSpoilerContainer:hover
	{
		background-color: transparent;
	}
	
		.NoJs .bbCodeSpoilerContainer:hover > .bbCodeSpoilerText
		{
			visibility: visible;
		}


@media (max-width:800px)
{
	.Responsive .bbCodeBlock,
	.Responsive.hasJs .bbCodeSpoilerText
	{
		margin-right: 0;
	}
}


/* --- bbcm_js.css --- */

.bbcmSpoilerBlock .bbcm_spoil_noscript_desc
{
	font-style:italic;
	font-size:7pt;
}

.bbcmSpoilerBlock .bbcm_spoiler,
.bbcmSpoilerBlock .button
{
	display: none;
}
 
.bbcmSpoilerBlock .bbcm_spoiler_noscript
{
	color:rgb(255,255,255);
	cursor: pointer;
}

.bbcmSpoilerBlock .bbcm_spoiler_noscript:hover
{
	color:rgb(44, 44, 44);
}

/* --- curse_footer.css --- */

/* Footer Ads */
.t-footer {
	clear:both;
	position:relative;
	height:635px;
}

.t-footer {
	font:12px/1.5 Arial,Helvetica,sans-serif;
	background-color:#151515;
	height:635px;
	text-shadow: 0 0 0 transparent, 0 -1px 0 rgba(0,0,0,0.6);
	position:relative;
	border-top:30px solid #262626;
}

.t-footer:before,.t-footer:after {
	content:"";
	display:table;
}

.t-footer:after {
	clear:both;
}

.ie8 .t-footer {
	zoom:1;
}

.t-footer a {
	color:white;
	font-family:Arial,Helvetica,sans-serif;
	white-space:nowrap;
}

.t-footer a:visited {
	color:white;
}

.t-footer a:hover {
	color:white;
	text-decoration:none;
}

.t-footer a>strong {
	color:#ff5f14;
}

.t-footer a>strong:hover {
	color:white;
}

.t-footer h1,.t-footer h2,.t-footer h3,.t-footer h4,.t-footer h5,.t-footer h6 {
	color:white;
	font-family:Arial,Helvetica,sans-serif;
	letter-spacing:0;
}

.t-footer .t-footer-wrapper {
	width:1000px;
	margin:0 auto;
	padding:40px 0;
}

.t-footer .t-footer-wrapper:before,.t-footer .t-footer-wrapper:after {
	content:"";
	display:table;
}

.t-footer .t-footer-wrapper:after {
	clear:both;
}

.ie8 .t-footer .t-footer-wrapper {
	zoom:1;
}

.t-footer .t-footer-curseInfo {
	float:left;
	width:31.96667%;
	margin-left:2.05%;
	margin-left:0;
	position:relative;
	z-index:2;
	border-right:1px solid #333;
}

.ie7 .t-footer .t-footer-curseInfo {
	width:30.96667%;
}

.t-footer .t-footer-curseInfo hgroup {
	margin-bottom:15px;
	margin-right:15px;
	margin-top:-40px;
}

.t-footer .t-footer-curseInfo hgroup h1 {
	background-image:url(/images/footer/curse-logo.png);
	margin-bottom:15px;
	width:225px;
	height:93px;
	text-indent:-99999px;
}

.t-footer .t-footer-curseInfo hgroup h2 {
	font-size:12px;
	font-weight:normal;
	color:white;
}

.t-footer .t-footer-curseInfo hgroup>strong {
	font-weight:bold;
}

.t-footer .t-footer-curseInfo .t-footer-signUp {
	background:#262626;
	-webkit-border-radius:8px;
	-moz-border-radius:8px;
	-ms-border-radius:8px;
	-o-border-radius:8px;
	-webkit-border-radius:8px; -moz-border-radius:8px; -khtml-border-radius:8px; border-radius:8px;
	padding:15px;
	margin:0 15px 30px 0;
	text-align:center;
}

.t-footer .t-footer-curseInfo .t-footer-signUp>h4,.t-footer .t-footer-curseInfo .t-footer-signUp h5 {
	font-size:20px;
	font-weight:bold;
	color:white;
	line-height:1.2em;
	text-shadow: 0 0 0 transparent, 0 1px 1px #000;
}

.t-footer .t-footer-curseInfo .t-footer-signUp h5 {
	margin-bottom:10px;
	font-weight:normal;
	color:#e6e6e6;
}

.t-footer .t-footer-curseInfo .t-footer-signUp .u-button {
	background-color:#EA8F20;
	background-image:0;
	background-image:0;
	background-image:0;
	background-image:0;
	background-image:linear-gradient(top,#ea8f20,#c56711);
	-webkit-border-radius:4px;
	-moz-border-radius:4px;
	-ms-border-radius:4px;
	-o-border-radius:4px;
	-webkit-border-radius:4px; -moz-border-radius:4px; -khtml-border-radius:4px; border-radius:4px;
	-webkit-box-shadow:inset 0 1px 0 rgba(255,255,255,0.2),0 1px 2px rgba(0,0,0,0.05);
	-moz-box-shadow:inset 0 1px 0 rgba(255,255,255,0.2),0 1px 2px rgba(0,0,0,0.05);
	-ms-box-shadow:inset 0 1px 0 rgba(255,255,255,0.2),0 1px 2px rgba(0,0,0,0.05);
	-o-box-shadow:inset 0 1px 0 rgba(255,255,255,0.2),0 1px 2px rgba(0,0,0,0.05);
	-webkit-box-shadow: inset 0 1px 0 rgba(255,255,255,0.2),0 1px 2px rgba(0,0,0,0.05); -moz-box-shadow: inset 0 1px 0 rgba(255,255,255,0.2),0 1px 2px rgba(0,0,0,0.05); -khtml-box-shadow: inset 0 1px 0 rgba(255,255,255,0.2),0 1px 2px rgba(0,0,0,0.05); box-shadow:inset 0 1px 0 rgba(255,255,255,0.2),0 1px 2px rgba(0,0,0,0.05);
	text-shadow: 0 0 0 transparent, 0 -1px 0 rgba(0,0,0,0.25);
	border-color:#C56711 #C56711 #EA8F20;
	border-color: rgb(0,0,0) rgba(0,0,0,0.1) rgba(0,0,0,0.25); border-color: rgba(0,0,0, 0.1) rgba(0,0,0,0.1) rgba(0,0,0,0.25); _border-color: rgb(0,0,0) rgba(0,0,0,0.1) rgba(0,0,0,0.25);
	overflow:hidden;
	color:#fff;
	padding:10px 30px;
	font-weight:bold;
	font-size:16px;
	display:block;
	text-align:center;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks:before,.t-footer .t-footer-curseInfo .t-footer-socialLinks:after {
	content:"";
	display:table;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks:after {
	clear:both;
}

.ie8 .t-footer .t-footer-curseInfo .t-footer-socialLinks {
	zoom:1;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li {
	float:left;
	width:23.4625%;
	margin-left:2.05%;
}

.ie7 .t-footer .t-footer-curseInfo .t-footer-socialLinks li {
	width:22.4625%;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li a {
	display:block;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li a i {
	display:block;
	margin:0 auto;
	background:url(/images/footer/icon-social-links.png) no-repeat 0 0;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li a i.u-icon-youtube {
	width:64px;
	height:26px;
	background-position:0 0;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li a i.u-icon-youtube:hover {
	background-position:0 -28px;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li a i.u-icon-twitter {
	width:37px;
	height:27px;
	background-position:-66px 0;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li a i.u-icon-twitter:hover {
	background-position:0 -56px;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li a i.u-icon-facebook {
	width:16px;
	height:32px;
	background-position:-105px 0;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li a i.u-icon-facebook:hover {
	background-position:-105px -34px;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li a i.u-icon-rss {
	width:27px;
	height:27px;
	background-position:-39px -56px;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li a i.u-icon-rss:hover {
	background-position:-68px -56px;
}

.t-footer .t-footer-curseInfo .t-footer-socialLinks li:first-child {
	margin-left:0;
}

.t-footer .t-footer-curseNetwork {
	float:left;
	width:65%;
	margin-left:2.05%;
	border-top:1px solid #333;
}

.ie7 .t-footer .t-footer-curseNetwork {
	width:64.98333%;
}

.t-footer .t-footer-curseNetwork header>h4 {
	position:relative;
	top:-9px;
	background:#151515;
	padding:0 10px 0 0;
	display:inline-block;
	font-size:14px;
	font-weight:bold;
}

.t-footer .t-footer-curseNetwork .t-footer-jumpLink {
	float:right;
	position:relative;
	top:-9px;
	padding:0 10px;
	font-size:10px;
	height:16px;
	line-height:16px;
	text-transform:uppercase;
	font-weight:bold;
	background:#383838;
	-webkit-border-radius:6px;
	-moz-border-radius:6px;
	-ms-border-radius:6px;
	-o-border-radius:6px;
	-webkit-border-radius:6px; -moz-border-radius:6px; -khtml-border-radius:6px; border-radius:6px;
}

.t-footer .t-footer-curseNetwork .t-footer-jumpLink:hover {
	background:#ff5f14;
	color:#fff;
}

.t-footer .t-footer-curseNetwork .t-footer-featured {
	border-bottom:1px solid #333;
	overflow:hidden;
	padding-bottom:1.5em;
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem {
	float:left;
	width:23.4625%;
	margin-left:2.05%;
}

.ie7 .t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem {
	width:22.4625%;
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem:first-child {
	margin-left:0;
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem h4 {
	text-indent:-9999px;
	display:block;
	width:146px;
	height:102px;
	background-repeat:no-repeat;
	background-position:0 0;
	margin:0;
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem.site-gw2g h4 {
	background-image:url(http://media-curse.cursecdn.com/attachments/73/537/featured-gw2g.png);
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem.site-lolpro h4 {
	background-image:url(http://media-curse.cursecdn.com/attachments/63/908/featured-lolpro.png);
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem.site-mmoc h4 {
	background-image:url(http://media-curse.cursecdn.com/attachments/63/909/featured-mmoc.png);
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem.site-gw2db h4 {
	background-image:url(http://media-curse.cursecdn.com/attachments/75/387/featured-gw2db.png);
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem a {
	display:block;
	cursor:pointer;
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem a:hover h4 {
	background-position:0 -102px;
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem dl {
	margin:0;
	background:#262626;
	-webkit-border-bottom-right-radius:8px;
	-moz-border-bottom-right-radius:8px;
	-ms-border-bottom-right-radius:8px;
	-o-border-bottom-right-radius:8px;
	-webkit-border-bottom-right-radius:8px; -moz-border-radius-bottomright:8px; -khtml-border-bottom-right-radius:8px; border-bottom-right-radius:8px;
	-webkit-border-bottom-left-radius:8px;
	-moz-border-bottom-left-radius:8px;
	-ms-border-bottom-left-radius:8px;
	-o-border-bottom-left-radius:8px;
	-webkit-border-bottom-left-radius:8px; -moz-border-radius-bottomleft:8px; -khtml-border-bottom-left-radius:8px; border-bottom-left-radius:8px;
	width:146px;
	padding:5px 10px;
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem dl dt {
	font-weight:bold;
	color:#fff;
}

.t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem dl dd {
	margin:0;
	font-size:11px;
	white-space:normal;
	line-height:13px;
	color:#ddd;
}

.t-footer .t-footer-curseNetwork .t-footer-browse {
	position:relative;
	padding-left:170px;
}

.t-footer .t-footer-curseNetwork .t-footer-browse:before,.t-footer .t-footer-curseNetwork .t-footer-browse:after {
	content:"";
	display:table;
}

.t-footer .t-footer-curseNetwork .t-footer-browse:after {
	clear:both;
}

.ie8 .t-footer .t-footer-curseNetwork .t-footer-browse {
	zoom:1;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li>a {
	position:absolute;
	left:0;
	width:150px;
	font-weight:bold;
	color:#4b4b4b;
	text-shadow: 0 0 0 transparent, 0 1px 0 #000;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li>a.j-selected,.t-footer .t-footer-curseNetwork .t-footer-browse>li>a:hover {
	background:#2c2c2c;
	color:#ff5f14;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li.t-footer-coreLinks>a {
	top:0;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li.t-footer-communityLinks>a {
	top:20px;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li.t-footer-databaseLinks>a {
	top:40px;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li.t-footer-wikiLinks>a {
	top:60px;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li>ul {
	display:none;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li>ul:before,.t-footer .t-footer-curseNetwork .t-footer-browse>li>ul:after {
	content:"";
	display:table;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li>ul:after {
	clear:both;
}

.ie8 .t-footer .t-footer-curseNetwork .t-footer-browse>li>ul {
	zoom:1;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li>ul>li {
	float:left;
	width:143px;
	margin:0 20px 2px 0;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li>ul>li a {
	display:block;
	background:#2c2c2c;
	padding:0 3px;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li>ul>li a:hover {
	background:#383838;
	color:#ff5f14;
}

.t-footer .t-footer-curseNetwork .t-footer-browse>li>ul.j-list-selected {
	display:block;
}

.t-footer .t-footer-curseLinks {
	background:#191919;
	clear:both;
}

.t-footer .t-footer-curseLinks>ul {
	width:1000px;
	margin:0 auto;
	text-align:center;
	padding:30px 0;
}

.t-footer .t-footer-curseLinks>ul:before,.t-footer .t-footer-curseLinks>ul:after {
	content:"";
	display:table;
}

.t-footer .t-footer-curseLinks>ul:after {
	clear:both;
}

.ie8 .t-footer .t-footer-curseLinks>ul {
	zoom:1;
}

.t-footer .t-footer-curseLinks>ul>li {
	display:0;
	-moz-box-orient:vertical;
	display:inline-block;
	vertical-align:middle;
	margin:0 8px;
	font-size:11px;
	text-transform:uppercase;
}

.t-footer .t-footer-curseLinks>ul>li a {
	color:#666;
}

.t-footer .t-footer-curseLinks>ul>li a:hover {
	color:#ff5f14;
}

.t-footer .t-footer-createdBy {
	background:#101010;
	clear:both;
	text-align:center;
	color:#4d4d4d;
	padding:20px 0 40px;
	text-transform:uppercase;
}

.t-footer .t-footer-createdBy>* {
	display:0;
	-moz-box-orient:vertical;
	display:inline-block;
	vertical-align:middle;
}

.t-footer .t-footer-createdBy .curse-logo {
	background-image:url(/images/footer/icon-curse-logo-footer.png);
	width:35px;
	height:50px;
	margin:0 1em;
}

.t-footer .t-footer-createdBy .happy-pants {
	display:block;
	clear:both;
	margin-bottom:0;
	padding:20px 0 0;
}

.t-footer .return-to-top {
	background:url(/images/footer/icon-back_to_top.png) no-repeat right center;
	padding-right:24px;
	position:absolute;
	top:-30px;
	width:1000px;
	margin:0 auto;
	text-align:right;
	display:block;
	font-size:11px;
	font-weight:bold;
	height:30px;
	line-height:30px;
}

.t-footer .return-to-top a:hover {
	color:#ff5f14;
}

/* ---------------------------------------------------------------------------
    Footer ad hack, remove after code push -JB (4/18/13)
      - Specificity issues due to old code
    --------------------------------------------------------------------------- */

/* Temp Wrapper */

.show-ads {
    position: relative;
}

/* Header */

.show-ads .t-footer .t-footer-curseNetwork {
    border-top: none;
}

.show-ads .t-footer-curseNetwork > header:first-child {
    border-top: 1px solid #333;
    width: 50%;
}

.show-ads .t-footer-curseNetwork > header:first-child .t-footer-jumpLink {
    margin-right: 10px;
    position: relative;
}

.show-ads .t-footer-curseNetwork > header:first-child .t-footer-jumpLink:after {
    background: #151515;
    content: "";
    height: 100%;
    position: absolute;
    left: 100%;
    width: 10px;
}

/* Featured Items */

.show-ads .t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem {
    float: none;
    margin-left: 0;
    overflow: hidden;
    width: 50%;
}

.show-ads .t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem h4 {
    float: left;
    position: relative;
    z-index: 2;
}

.show-ads .t-footer .t-footer-curseNetwork .t-footer-featured .t-footer-featureItem dl {
    -webkit-border-radius: 0 8px 8px 0; -moz-border-radius: 0 8px 8px 0; -khtml-border-radius: 0 8px 8px 0; border-radius: 0 8px 8px 0;
    height: 91px;
    overflow: hidden;
    padding-left: 28px;
    position: relative;
    top: 11px; left: -10px;
    width: auto;
}

/* Remove 3rd & 4th featured sites */

.show-ads .t-footer .t-footer-featureItem:nth-child(3),
.show-ads .t-footer .t-footer-featureItem:nth-child(4) {
    position: absolute;
    left: -99999px;
}

/* Med Rect */

.show-ads .footer-ad-medRect {
    margin-right: -490px;
    position: absolute;
    top: 45px; right: 50%;
}

/* --- likes_summary.css --- */

.likesSummary
{
	overflow: hidden; zoom: 1;
	font-size: 11px;
}

	.LikeText
	{
		float: left;
	}
	
	.likeInfo
	{
		float: right;
	}

/* --- login_bar.css --- */

/** Login bar basics **/

#loginBar .pageContent 
{
	color: rgb(249, 253, 255);
background-color: rgb(3, 50, 81);

}

	#loginBar .ctrlWrapper
	{
		margin: 0 10px;
	}

	#loginBar .pageContent
	{
		padding-top: 0;
		position: relative;
		_height: 0px;
	}

	#loginBar a
	{
		color: rgba(255,255,255,.8);

	}

	#loginBar form
	{
		padding: 16px 0;
margin: 0 auto;
display: none;
line-height: 20px;
position: relative;

	}
	
		#loginBar .xenForm .ctrlUnit,		
		#loginBar .xenForm .ctrlUnit > dt label
		{
			margin: 0;
			border: none;
		}
	
		#loginBar .xenForm .ctrlUnit > dd
		{
			position: relative;
		}
	
	#loginBar .lostPassword,
	#loginBar .lostPasswordLogin
	{
		font-size: 11px;
	}
	
	#loginBar .rememberPassword
	{
		font-size: 11px;
	}

	#loginBar .textCtrl
	{
		color: #FFFFFF;
background: url(rgba.php?r=0&g=0&b=0&a=38); background: rgba(0, 0, 0, 0.15); _filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=#26000000,endColorstr=#26000000);
border-color:  rgb(0, 0, 0); border-color:  rgba(0, 0, 0, 0.15); _border-color:  rgb(0, 0, 0);

	}
	
	#loginBar .textCtrl[type=text]
	{
		font-weight: bold;

	}

	#loginBar .textCtrl:-webkit-autofill /* http://code.google.com/p/chromium/issues/detail?id=1334#c35 */
	{
		background: url(rgba.php?r=0&g=0&b=0&a=38) !important; background: rgba(0, 0, 0, 0.15) !important; _filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=#26000000,endColorstr=#26000000);
		color: #FFFFFF;
	}

	#loginBar .textCtrl:focus
	{
		background: url(rgba.php?r=0&g=0&b=0&a=76) none; background: rgba(0, 0, 0, 0.3) none; _filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=#4C000000,endColorstr=#4C000000);

	}
	
	#loginBar input.textCtrl.disabled
	{
		color: rgb(127, 127, 127);
background-color: #000;
border-style: dashed;

	}
	
	#loginBar .button
	{
		min-width: 85px;
		*width: 85px;
	}
	
		#loginBar .button.primary
		{
			font-weight: bold;
		}
		
/** changes when eAuth is present **/

#loginBar form.eAuth
{
	-x-max-width: 700px; /* normal width + 170px */
}

	#loginBar form.eAuth .ctrlWrapper
	{
		border-right: 1px dotted rgb(73, 147, 197);
		margin-right: 200px;
		-webkit-box-sizing: border-box; -moz-box-sizing: border-box; -ms-box-sizing: border-box; box-sizing: border-box;
	}

	#loginBar form.eAuth #eAuthUnit
	{
		position: absolute;
		top: 0px;
		right: 10px;
	}

		#eAuthUnit li
		{
			margin-top: 10px;
			line-height: 0;
		}
	
/** handle **/

#loginBar #loginBarHandle label 
{
	font-weight: bold;
font-size: 13px;
color: #FFF;
background-color: rgb(3, 50, 81);
padding: 0 8px;
-webkit-border-top-left-radius: 0; -moz-border-radius-topleft: 0; -khtml-border-top-left-radius: 0; border-top-left-radius: 0;
-webkit-border-top-right-radius: 0; -moz-border-radius-topright: 0; -khtml-border-top-right-radius: 0; border-top-right-radius: 0;
-webkit-border-bottom-right-radius: 2px; -moz-border-radius-bottomright: 2px; -khtml-border-bottom-right-radius: 2px; border-bottom-right-radius: 2px;
-webkit-border-bottom-left-radius: 2px; -moz-border-radius-bottomleft: 2px; -khtml-border-bottom-left-radius: 2px; border-bottom-left-radius: 2px;
position: absolute;
right: 0;
display: inline-block;
text-align: center;
z-index: 1;
line-height: 30px;
height: 30px;

}


@media (max-width:800px)
{
	.Responsive #loginBar form.eAuth .ctrlWrapper
	{
		border-right: none;
		margin-right: 10px;
	}

	.Responsive #loginBar form.eAuth #eAuthUnit
	{
		position: static;
		width: 180px;
		margin: 0 auto 10px;
	}
}


/* --- message.css --- */



.messageList
{
	
}

.messageList .message
{
	background-color: #FFFFFF;
padding: 8px;

}

/* clearfix */ .messageList .message { zoom: 1; } .messageList .message:after { content: '.'; display: block; height: 0; clear: both; visibility: hidden; }

/*** Message block ***/

.message .messageInfo
{
	background-color: transparent;
padding: 0;
border-bottom: 1px none black;

	zoom: 1;
}

	.message .newIndicator
	{
		font-weight: bold;
font-size: 14px;
color: rgb(249, 253, 255);
background-color: rgb(255, 142, 20);
background-repeat: repeat-x;
background-position: top;
padding: 3px 6px;
margin: 10px -21px !important 5px 5px;
-webkit-border-radius: 2px; -moz-border-radius: 2px; -khtml-border-radius: 2px; border-radius: 2px;
-webkit-border-top-right-radius: 0; -moz-border-radius-topright: 0; -khtml-border-top-right-radius: 0; border-top-right-radius: 0;
display: block;
float: right;
position: relative;

		
		margin-right: -21px;
	}
	
		.message .newIndicator span
		{
			border: 4px solid rgb(3, 78, 127);
border-top-width: 0;
border-right: 8px solid transparent;
border-left-width: 0;
position: absolute;
right: 0;
top: -4px;

		}

	.message .messageContent
	{
		padding: 8px 0;
min-height: 100px;
overflow: hidden;
*zoom: 1;

	}
	
	.message .messageTextEndMarker
	{
		height: 0;
		font-size: 0;
		overflow; hidden;
	}
	
	.message .editDate
	{
		text-align: right;
		margin-top: 5px;
		font-size: 11px;
		color: rgb(127, 127, 127);
	}

	.message .signature
	{
		font-size: 9pt;
color: rgb(127, 127, 127);
padding-top: 8px;
padding-bottom: 8px;
margin-top: 8px;
margin-bottom: 8px;
border: 0 dashed rgb(175, 207, 226);
border-top-width: 1px;
border-bottom-width: 1px;

	}

	.message .messageMeta
	{
		font-size: 12px;
padding-top: 5px;
padding-bottom: 5px;
margin-bottom: -8px;
overflow: hidden;
zoom: 1;
-webkit-box-sizing: border-box; -moz-box-sizing: border-box; -ms-box-sizing: border-box; box-sizing: border-box;

	}

		.message .privateControls
		{
			margin-top: 5px;
margin-bottom: 5px;
float: left;

		}

		.message .publicControls
		{
			margin-top: 5px;
margin-bottom: 5px;
float: right;

		}
		
			.message .privateControls .item
			{
				margin-right: 10px;
				float: left;
			}

				.message .privateControls .item:last-child
				{
					margin-right: 0;
				}

			.message .publicControls .item
			{
				margin-left: 10px;
				float: left;
			}
	
				.message .messageMeta .control
				{
					background-color: #FFFFFF;
padding-right: 8px;
padding-left: 8px;
margin: 0 1px 4px 0;
border: 1px solid rgb(175, 207, 226);
-webkit-border-radius: 2px; -moz-border-radius: 2px; -khtml-border-radius: 2px; border-radius: 2px;
line-height: 24px;

				}
				
					.message .messageMeta .control:focus
					{
						
					}
				
					.message .messageMeta .control:hover
					{
						text-decoration: none;

					}
				
					.message .messageMeta .control:active
					{
						
					}
	/*** multiquote +/- ***/
		
		
	
		.messageNotices li
	{
		font-size: 12px;
background: rgb(248,251,253) url('styles/uix/xenforo/gradients/form-button-white-25px.png') repeat-x top;
padding: 5px;
margin: 8px 0;
border: 1px solid rgb(248,251,253);
-webkit-border-radius: 2px; -moz-border-radius: 2px; -khtml-border-radius: 2px; border-radius: 2px;
line-height: 16px;

	}
	
		.messageNotices .icon
		{
			float: right;
			width: 16px;
			height: 16px;
			background: url('styles/uix/xenforo/xenforo-ui-sprite.png') no-repeat 1000px 1000px;
		}
	
			.messageNotices .warningNotice .icon { background-position: -48px -32px; }		
			.messageNotices .deletedNotice .icon { background-position: -64px -32px; }		
			.messageNotices .moderatedNotice .icon {background-position: -32px -16px; }
	
	.message .likesSummary
	{
		color: rgb(6, 59, 94);
background-color: rgb(248,251,253);
padding: 8px;
margin-top: 8px;
border: 1px solid rgb(194,218,234);
-webkit-border-radius: 2px; -moz-border-radius: 2px; -khtml-border-radius: 2px; border-radius: 2px;

	}
	
	.message .messageText > *:first-child
	{
		margin-top: 0;
	}

/* inline moderation changes */

.InlineModChecked .messageUserBlock,
.InlineModChecked .messageInfo,
.InlineModChecked .messageNotices,
.InlineModChecked .bbCodeBlock .type,
.InlineModChecked .bbCodeBlock blockquote,
.InlineModChecked .attachedFiles .attachedFilesHeader,
.InlineModChecked .attachedFiles .attachmentList
{
	background-color: rgb(204, 241, 252);

}

.InlineModChecked .messageUserBlock div.avatarHolder,
.InlineModChecked .messageUserBlock .extraUserInfo
{
	background: transparent;
}

.InlineModChecked .messageUserBlock .arrow span
{
	border-left-color: rgb(204, 241, 252);
}

/* message list */

.messageList .newMessagesNotice
{
	margin: 10px auto;
	padding: 5px 10px;
	-webkit-border-radius: 5px; -moz-border-radius: 5px; -khtml-border-radius: 5px; border-radius: 5px;
	border: 1px solid rgb(242, 250, 255);
	background: rgb(249, 253, 255) url(styles/uix/xenforo/gradients/category-23px-light.png) repeat-x top;
	font-size: 11px;
}

/* deleted / ignored message placeholder */

.messageList .message.placeholder
{
}

.messageList .placeholder .placeholderContent
{	
	overflow: hidden; zoom: 1;
	color: rgb(94, 190, 255);
	font-size: 11px;
}

	.messageList .placeholder a.avatar
	{
		float: left;
		display: block;
	}
	
		.messageList .placeholder a.avatar img
		{
			display: block;
			width: 32px;
			height: 32px;
		}
		
	.messageList .placeholder .privateControls
	{
		margin-top: -5px;
	}
	

/* messages remaining link */

.postsRemaining a,
a.postsRemaining
{
	font-size: 11px;
	color: rgb(127, 127, 127);
}


@media (max-width:800px)
{
	.Responsive .message .newIndicator
	{
		margin-right: 0;
		-webkit-border-top-right-radius: 2px; -moz-border-radius-topright: 2px; -khtml-border-top-right-radius: 2px; border-top-right-radius: 2px;
	}
	
		.Responsive .message .newIndicator span
		{
			display: none;
		}
}

@media (max-width:480px)
{
	.Responsive .message .messageInfo
	{
		margin-left: 0;
		padding: 0 10px;
	}

	.Responsive .message .messageContent
	{
		min-height: 0;
	}	

	.Responsive .message .newIndicator
	{
		margin-right: -5px;
		margin-top: -16px;
	}

	.Responsive .message .postNumber,
	.Responsive .message .authorEnd
	{
		display: none;
	}
	
	.Responsive .message .signature
	{
		display: none;
	}
	
	.Responsive .messageList .placeholder a.avatar
	{
		margin-right: 10px;
	}
}


/* --- message_user_info.css --- */

.messageUserInfo
{
	background-color: rgb(249, 253, 255);
float: left;
width: 140px;

}

	.messageUserBlock
	{
		background-color: rgb(242, 250, 255);
border: 1px solid rgb(175, 207, 226);
-webkit-border-radius: 2px; -moz-border-radius: 2px; -khtml-border-radius: 2px; border-radius: 2px;

		
		position: relative;
	}
		
		.messageUserBlock div.avatarHolder
		{
			background-color: rgb(242, 250, 255);
padding: 8px;
-webkit-border-radius: 2px; -moz-border-radius: 2px; -khtml-border-radius: 2px; border-radius: 2px;
-webkit-border-bottom-right-radius: 0; -moz-border-radius-bottomright: 0; -khtml-border-bottom-right-radius: 0; border-bottom-right-radius: 0;
-webkit-border-bottom-left-radius: 0; -moz-border-radius-bottomleft: 0; -khtml-border-bottom-left-radius: 0; border-bottom-left-radius: 0;

			
			position: relative;	
		}
		
			.messageUserBlock div.avatarHolder .avatar
			{
				display: block;
				font-size: 0;
			}
			
			.messageUserBlock div.avatarHolder .onlineMarker
			{
				position: absolute;
				top: 7px;
				left: 7px;
				
				color: rgb(127, 185, 0);
border: 7px solid transparent;
border-top-color: rgb(127, 185, 0);
border-left-color: rgb(127, 185, 0);
-webkit-border-top-left-radius: 5px; -moz-border-radius-topleft: 5px; -khtml-border-top-left-radius: 5px; border-top-left-radius: 5px;
-webkit-border-top-right-radius: 3px; -moz-border-radius-topright: 3px; -khtml-border-top-right-radius: 3px; border-top-right-radius: 3px;
-webkit-border-bottom-left-radius: 3px; -moz-border-radius-bottomleft: 3px; -khtml-border-bottom-left-radius: 3px; border-bottom-left-radius: 3px;

			}
			
		.messageUserBlock h3.userText
		{
			background-color: rgb(228, 240, 247);
padding: 8px;
border-width: 0;

		}
		
		.messageUserBlock .userBanner
		{
			display: block;
			margin-bottom: 5px;
			margin-left: -14px;
			margin-right: -14px;
		}
		
		.messageUserBlock .userBanner:last-child
		{
			margin-bottom: 0;
		}
	
		.messageUserBlock a.username
		{
			font-weight: bold;
display: block;
overflow: hidden;
line-height: 16px;

			
		}
		
		.messageUserBlock .userTitle
		{
			font-size: 11px;
display: block;

		}
		
		.messageUserBlock .extraUserInfo
		{
			font-size: 12px;
padding: 4px 6px;
border-width: 0;
border-style: solid;
-webkit-border-radius: 2px; -moz-border-radius: 2px; -khtml-border-radius: 2px; border-radius: 2px;
-webkit-border-top-left-radius: 0; -moz-border-radius-topleft: 0; -khtml-border-top-left-radius: 0; border-top-left-radius: 0;
-webkit-border-top-right-radius: 0; -moz-border-radius-topright: 0; -khtml-border-top-right-radius: 0; border-top-right-radius: 0;

		}
		
			.messageUserBlock .extraUserInfo dl
			{
				margin: 2px 0 0;
			}
							
			.messageUserBlock .extraUserInfo img
			{
				max-width: 100%;
			}
		
		.messageUserBlock .arrow
		{
			position: absolute;
			top: 10px;
			right: -10px;
			
			display: block;
			width: 0px;
			height: 0px;
			line-height: 0px;
			
			border: 10px solid transparent;
			border-left-color: rgb(175, 207, 226);
			-moz-border-left-colors: rgb(175, 207, 226);
			border-right: none;
			
			/* Hide from IE6 */
			_display: none;
		}
		
			.messageUserBlock .arrow span
			{
				position: absolute;
				top: -10px;
				left: -11px;
				
				display: block;
				width: 0px;
				height: 0px;
				line-height: 0px;
				
				border: 10px solid transparent;
				border-left-color: rgb(242, 250, 255);
				-moz-border-left-colors: rgb(242, 250, 255);
				border-right: none;
			}


@media (max-width:480px)
{
	.Responsive .messageUserInfo
	{
		float: none;
		width: auto; 
	}

	.Responsive .messageUserBlock
	{
		overflow: hidden;
		margin-bottom: 5px;
		position: relative;
	}

	.Responsive .messageUserBlock div.avatarHolder
	{
		float: left;
		padding: 5px;
	}

		.Responsive .messageUserBlock div.avatarHolder .avatar img
		{
			width: 48px;
		}
		
		.Responsive .messageUserBlock div.avatarHolder .onlineMarker
		{
			top: 4px;
			left: 4px;
			border-width: 6px;
		}

	.Responsive .messageUserBlock h3.userText
	{
		margin-left: 64px;
	}
	
	.Responsive .messageUserBlock .userBanner
	{
		max-width: 150px;
		margin-left: 0;
		margin-right: 0;
		-webkit-border-top-left-radius: 3px; -moz-border-radius-topleft: 3px; -khtml-border-top-left-radius: 3px; border-top-left-radius: 3px;
		-webkit-border-top-right-radius: 3px; -moz-border-radius-topright: 3px; -khtml-border-top-right-radius: 3px; border-top-right-radius: 3px;
		position: static;
		display: inline-block;
	}
	
		.Responsive .messageUserBlock .userBanner span
		{
			display: none;
		}

	.Responsive .messageUserBlock .extraUserInfo
	{
		display: none;
	}

	.Responsive .messageUserBlock .arrow
	{
		display: none;
	}
}


/* --- moderator_bar.css --- */

#moderatorBar
{
	background-color: rgb(0, 32, 52);
	border-bottom: 1px solid rgb(94, 190, 255);	
	font-size: 11px;
}

/*#moderatorBar
{
	-webkit-box-shadow: 0 0 5px rgb(73, 147, 197); -moz-box-shadow: 0 0 5px rgb(73, 147, 197); -khtml-box-shadow: 0 0 5px rgb(73, 147, 197); box-shadow: 0 0 5px rgb(73, 147, 197);
	width: 100%;
	position: fixed;
	top: 0px;
	z-index: 100;
}

body
{
	padding-top: 25px;
}*/

/* clearfix */ #moderatorBar { zoom: 1; } #moderatorBar:after { content: '.'; display: block; height: 0; clear: both; visibility: hidden; }

#moderatorBar .pageContent
{
	padding: 2px 0;
	overflow: auto;
}

#moderatorBar a
{
	display: inline-block;
	padding: 2px 10px;
	-webkit-border-radius: 3px; -moz-border-radius: 3px; -khtml-border-radius: 3px; border-radius: 3px;
}

#moderatorBar a,
#moderatorBar .itemCount
{
	color: rgb(242, 250, 255);
}

	#moderatorBar a:hover
	{
		text-decoration: none;
		background-color: rgb(3, 78, 127);
		color: rgb(249, 253, 255);
	}

/* TODO: maybe sort out the vertical alignment of the counters so they they are properly centered */

#moderatorBar .itemLabel,
#moderatorBar .itemCount
{
	display: inline-block;
	height: 16px;
	line-height: 16px;
}

#moderatorBar .itemCount
{	
	background: rgb(3, 78, 127);
	padding-left: 6px;
	padding-right: 6px;
	
	text-align: center;
	
	font-weight: bold;
	
	-webkit-border-radius: 2px; -moz-border-radius: 2px; -khtml-border-radius: 2px; border-radius: 2px;
	text-shadow: none;
}

	#moderatorBar .itemCount.alert
	{
		background: #e03030;
		color: white;
		-webkit-box-shadow: 2px 2px 5px rgba(0,0,0, 0.25); -moz-box-shadow: 2px 2px 5px rgba(0,0,0, 0.25); -khtml-box-shadow: 2px 2px 5px rgba(0,0,0, 0.25); box-shadow: 2px 2px 5px rgba(0,0,0, 0.25);
	}
	
#moderatorBar .adminLink
{
	float: right;
}

#moderatorBar .permissionTest,
#moderatorBar .permissionTest:hover
{
	background: #e03030;
	color: white;
	-webkit-box-shadow: 2px 2px 5px rgba(0,0,0, 0.25); -moz-box-shadow: 2px 2px 5px rgba(0,0,0, 0.25); -khtml-box-shadow: 2px 2px 5px rgba(0,0,0, 0.25); box-shadow: 2px 2px 5px rgba(0,0,0, 0.25);
	font-weight: bold;
}

/* --- share_page.css --- */

.sharePage
{
}

/* clearfix */ .sharePage { zoom: 1; } .sharePage:after { content: '.'; display: block; height: 0; clear: both; visibility: hidden; }

	.sharePage .shareControl
	{
		float: left;
	}
	
	.sharePage .tweet
	{
		margin-right: 30px;
	}

	.sharePage .facebookLike .label
	{
		font-size: 11px;
		line-height: 24px;
		float: left;
		margin-right: 7px;
		display: none;
	}
	
	.sharePage iframe
	{
		height: 20px;
	}
	
	.sharePage .facebookLike iframe
	{
		z-index: 52;
	}
	



@media (max-width:480px)
{
	.Responsive .sharePage
	{
		display: none;
	}
}


/* --- thread_view.css --- */

.thread_view .threadAlerts
{
	border: 1px solid rgb(249, 253, 255);
	-webkit-border-radius: 5px; -moz-border-radius: 5px; -khtml-border-radius: 5px; border-radius: 5px;
	font-size: 11px;
	margin: 10px 0;
	padding: 5px;
	line-height: 16px;
	background-image: url('styles/uix/xenforo/gradients/form-button-white-25px.png');
}
	
	.thread_view .threadAlerts dt
	{
		color: rgb(228, 240, 247);
		display: inline;
	}
	
	.thread_view .threadAlerts dd
	{
		color: rgb(3, 78, 127);
		font-weight: bold;
		display: inline;
	}
	
		.thread_view .threadAlerts .icon
		{
			float: right;
			width: 16px;
			height: 16px;
			margin-left: 5px;
			background: url('styles/uix/xenforo/xenforo-ui-sprite.png') no-repeat -1000px -1000px;
		}
		
			.thread_view .threadAlerts .deletedAlert .icon { background-position: -64px -32px; }
			.thread_view .threadAlerts .moderatedAlert .icon { background-position: -32px -16px; }
			.thread_view .threadAlerts .lockedAlert .icon { background-position: -16px -16px; }
	
.thread_view .threadAlerts + * > .messageList
{
	border-top: none;
}

.thread_view .threadNotices
{
	background-color: #FFFFFF;
	border: 1px solid rgb(242, 250, 255);
	-webkit-border-radius: 5px; -moz-border-radius: 5px; -khtml-border-radius: 5px; border-radius: 5px;
	padding: 10px;
	margin: 10px auto;
}

.thread_view .InlineMod
{
	overflow: hidden; zoom: 1;
}
